#include <stdio.h>
#include <stdlib.h>

typedef long long ll;

int cmp(const void *a, const void *b) {
    ll x = *(ll*)a;
    ll y = *(ll*)b;
    if (x < y) return -1;
    if (x > y) return 1;
    return 0;
}

ll count_greetings(ll *a, int n) {
    qsort(a, n, sizeof(ll), cmp);

    ll res = 0;
    for (int i = 0; i < n; ) {
        int j = i;
        while (j < n && a[j] == a[i]) j++;
        ll k = j - i;
        res += k * (k - 1);   // <-- NEMA /2
        i = j;
    }
    return res;
}

int main() {
    int n;
    scanf("%d", &n);

    ll *xs  = malloc(n * sizeof(ll)); // x
    ll *ys  = malloc(n * sizeof(ll)); // y
    ll *sum = malloc(n * sizeof(ll)); // x + y
    ll *dif = malloc(n * sizeof(ll)); // x - y

    for (int i = 0; i < n; i++) {
        ll x, y;
        scanf("%lld %lld", &x, &y);
        xs[i]  = x;
        ys[i]  = y;
        sum[i] = x + y;
        dif[i] = x - y;
    }

    ll ans = 0;
    ans += count_greetings(xs, n);   // Istok–Zapad
    ans += count_greetings(ys, n);   // Sever–Jug
    ans += count_greetings(sum, n);  // N–E, S–W
    ans += count_greetings(dif, n);  // N–W, S–E

    printf("%lld\n", ans);

    free(xs);
    free(ys);
    free(sum);
    free(dif);
    return 0;
}